/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPListen.java
 * Contents: Actions in State LISTEN of TCP-FSM
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPListen
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPListen {

SegArrive parent;
SessionControlBlock newtcb;

/*****************************************
* Methode      : TCPListen
* Beschreibung : prft das ankommende Segment auf gesetzte Flags und andere Elemente des Tcp-Header
*                und handelt danach 
* Parameter    : short local port, short destination port, int passive oder active
* Rueckgabewert: SessionControlBlock mit den neuen Werten fr den Verbindungstatus
*****************************************/
public SessionControlBlock TCPListen(SegArrive home, SessionControlBlock newtcb) {

    this .parent = home;
    this .newtcb = newtcb;

    while(true) {
      if(parent.segment1.RST == 1) {       // Segment enthlt ein RST
        parent. fromnet.removeElementAt(0);//Segment wegwerfen und keine Antwort schicken
        break;                             // zurck, warten auf ein Packet
      }
      if(parent.segment1.SYN == 1) {       // Segment enthaelt ein SYN, TCPStatus aendern und beantworten.
        newtcb.TcpStatus = 3;
        parent. tcppro.darfsenden.getrighttosend();
        newtcb.RCVNXT = parent.segment1.Seqnumb +1;
        newtcb.IRS = parent.segment1.Seqnumb;
        int k = new SqNbGenerator().getISS(parent.time);
        TcpSegment s = new TcpSegment();
        s.Lpnumb = parent.segment1.Dpnumb;
        s.SYN = 1;
        s.ACK = 1;
        s.Dpnumb = parent.segment1.Lpnumb; s.Seqnumb =k;
        s.Acknumb = newtcb.RCVNXT;
        newtcb.RCVWND = parent.segment1.Wsize;
        s.Hdlength = 5;
        String st = "SYN_RCVD";
        s.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
        s = new Checksum().build(s);
        newtcb.SNDNXT = k+1;
        newtcb.SNDUNA = k;
        newtcb.ISS = k;
        if(newtcb.Dpnumb == 0) newtcb.Dpnumb = parent.segment1.Lpnumb; //und Daten
        //Aufbau einer neuen Verbindung vom Close aus;
        parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(s,true,new Date().getTime(),true,st));
        parent. tonet.putElement(s);
        parent. tcppro.darfsenden.giverighttosend();
        parent. fromnet.removeElementAt(0);
        Timeout t0 = new Timeout(parent.halt,parent.tcppro,3,parent.tcb,newtcb);
        break;
      }
      if(parent.segment1.ACK == 1) { // Segment enthaelt ein ACK, ein RST schicken
        TcpSegment sg = new TcpSegment();
        sg.Lpnumb = parent.segment1.Dpnumb;
        sg.RST = 1;
        sg.Wsize =(short)(newtcb.toclientbuffer.capacity()-newtcb.toclientbuffer.size());
        sg.Dpnumb = parent.segment1.Lpnumb;
        sg.Seqnumb =parent.segment1.Acknumb;
        sg.Hdlength = 5;
        String s = "LISTEN";
        sg = new Checksum().build(sg);
        parent. tcppro.history.addElement(new BuildHTcpSegment().BuildHTcpSegment(sg,true,new Date().getTime(),true,s));
        parent. tonet.putElement(sg);
        parent. fromnet.removeElementAt(0);
        break;
      }
      parent. fromnet.removeElementAt(0);
    } //END while(true)
    return newtcb;
} //END methode TCPListen
} //END class TCPListen
